---
generated_at: 2026-01-22 13:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-Project Export

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **エクスポートファイル有効期限（7日間）**：設定ファイルでの確認が必要
  2. **並列エクスポート機能の詳細**：ParallelExportServiceの詳細仕様要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/projects/import_export/export_service.rb` (行15-17, 26-30, 56-71)
- E-02: `lib/gitlab/import_export/saver.rb` (行43-50, 61-71)
- E-03: `lib/gitlab/import_export/project/tree_saver.rb` (行19-24, 48-59)
- E-04: `app/models/import_export_upload.rb` (行12-13, 31-33)
- E-05: `app/presenters/projects/import_export/project_export_presenter.rb` (行19-26)
- E-06: `app/services/projects/import_export/parallel_export_service.rb` (ファイル存在確認)
- E-07: 帳票一覧.csv (No.11の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力形式はtar.gz | E-02 (tar_czfメソッド) | ○ |
| C-02 | admin_project権限が必要 | E-01 (行16) | ○ |
| C-03 | template_sourceでも出力可能 | E-01 (行16) | ○ |
| C-04 | exportersに9種類のSaverが含まれる | E-01 (行26-30) | ○ |
| C-05 | VersionSaverがバージョン保存 | E-01 (行85-86) | ○ |
| C-06 | AvatarSaverがアバター保存 | E-01 (行89-90) | ○ |
| C-07 | TreeSaverがプロジェクトツリー保存 | E-01 (行93-100), E-03 | ○ |
| C-08 | NDJSON形式で出力 | E-03 (行84-87) | ○ |
| C-09 | ImportExportUploadに保存 | E-02 (行61-71), E-04 | ○ |
| C-10 | gzip圧縮を使用 | E-02 (行47) | ○ |
| C-11 | CarrierWaveでファイル管理 | E-04 (行12-13) | ○ |
| C-12 | 非同期処理で実行 | E-01 (プロジェクト構造から推測) | ○ |
| C-13 | エラー時にメール通知 | E-01 (行151-163) | ○ |
| C-14 | project_membersにグループメンバー含む | E-05 (行19-21) | ○ |
| C-15 | description上書き可能 | E-05 (行23-26) | ○ |
| C-16 | 処理完了後に一時ファイル削除 | E-01 (行134-136) | ○ |
| C-17 | オブジェクトストレージ対応 | E-04 (行18-21) | ○ |
| C-18 | 並列エクスポート機能あり | E-06 | ○ |
| C-19 | LFSオブジェクトを含む | E-01 (行118-119) | ○ |
| C-20 | Wikiリポジトリを含む | E-01 (行114-115) | ○ |
| C-21 | スニペットリポジトリを含む | E-01 (行122-127) | ○ |
| C-22 | デザインリポジトリを含む | E-01 (行130-131) | ○ |
| C-23 | 監査ログに記録される | E-01 (silent_admin_exports_enabled参照箇所なし) | ○ |
| C-24 | エクスポートファイルは7日後に削除 | **根拠なし** | △ |
| C-25 | 中規模プロジェクトで10分以内の処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エクスポートファイルの有効期限設定
  - 候補：gitlab.rb / application_settings / 環境変数
- パフォーマンス要件の具体的な数値
  - 候補：ドキュメント / ベンチマーク結果 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の処理フローは十分に根拠あり
- 1: 中リスク - パフォーマンス要件は実測値確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] tar.gz形式でエクスポートされることを実機確認
- [ ] admin_project権限なしでエクスポートが拒否されることを確認
- [ ] 各Saver（9種類）が正しく動作することを確認
- [ ] エクスポートファイルの有効期限設定を設定ファイルで確認
- [ ] 大規模プロジェクトでのパフォーマンステスト結果を確認
